' I2CREAD and I2WRITE Commands
' 24LC128  EEPROM 
' Write to the first 16 locations of an external serial EEPROM
' Read first 16 locations back and send to serial out repeatedly
' Note: for EEPROMS with byte-sized address

        INCLUDE "modedefs.bas"          ' Include serial modes

SO      VAR     PORTC.6                       ' Define serial output pin
DPIN    VAR     PORTC.4                 ' I2C data pin
CPIN    VAR     PORTC.3                 ' I2C clock pin
B0      VAR     BYTE
DEFINE  OSC     10

NOW:    B0 = $55
        GOSUB OUT_PORT
        B0 = $AA
        GOSUB OUT_PORT
        GOTO  NOW
        
OUT_PORT:       I2CWrite DPIN,CPIN,$70,[B0]  ' Write each location's address to itself
                Pause 500                ' Delay 10ms after each write
                RETURN
        
